/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.tags;

import com.ibm.hwmca.fw.servlet.helptools.FDARetriever;
import com.ibm.hwmca.fw.util.auimlcvt.AUIMLParser;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.AuimlJSPTools;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.TagUtils;
import com.ibm.hwmca.fw.util.auimlcvt.help.HelpRecordUtility;
import java.beans.Introspector;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractAuimlTag {
    public static final boolean useELExpressions = false;
    private Element auimlElement;
    Document hmcmlDocument;
    private String rscAttributes;
    private String[] relatedAttributes;
    Element hmcmlMountPoint;
    Element hmcmlElement;
    Element position;
    Element metaParent;
    Element metaPlacement;
    static int insetConversionFactor = 10;

    public void setMetaParent(Element metaParent) {
        this.metaParent = metaParent;
    }

    public Element getMetaPlacement() {
        if (this.hmcmlElement == null) {
            this.metaPlacement = this.metaParent;
        } else if (this.metaPlacement == null) {
            Element tableParent;
            this.metaPlacement = this.hmcmlDocument.createElementNS("acvt", "Node");
            String id = this.hmcmlElement.getNamespaceURI() != null && this.hmcmlElement.getNamespaceURI().equals("hmc") ? this.hmcmlElement.getAttribute("id") : this.hmcmlElement.getAttributeNS("hmc", "id");
            if ((id == null || id.equals("")) && this.hmcmlElement.getTagName().equals("table") && (tableParent = (Element)this.hmcmlElement.getParentNode()) != null) {
                id = tableParent.getNamespaceURI() != null && tableParent.getNamespaceURI().equals("hmc") ? tableParent.getAttribute("id") : tableParent.getAttributeNS("hmc", "id");
            }
            if (id != null && !id.equals("")) {
                this.metaPlacement.setAttribute("id", id);
                if (this.metaParent == null) {
                    this.metaParent = (Element)this.hmcmlDocument.getElementsByTagNameNS("acvt", "DocStructure").item(0);
                }
                this.metaParent.appendChild(this.metaPlacement);
            } else {
                this.metaPlacement = this.metaParent;
            }
        }
        return this.metaPlacement;
    }

    public void setHmcmlElement(Element hmcmlElement) {
        this.hmcmlElement = hmcmlElement;
    }

    public Element getHmcmlElement() {
        return this.hmcmlElement;
    }

    public void setHmcmlMountPoint(Element hmcmlMountPoint) {
        this.hmcmlMountPoint = hmcmlMountPoint;
    }

    public Element getHmcmlMountPoint() {
        return this.hmcmlMountPoint;
    }

    public abstract void startHMCMLTag();

    public void endHMCMLTag() {
    }

    public AbstractAuimlTag(Element auimlElement, Document hmcmlDocument, String rscAttributes, String[] relatedAttributes) {
        this.auimlElement = auimlElement;
        this.hmcmlDocument = hmcmlDocument;
        this.rscAttributes = rscAttributes;
        this.relatedAttributes = new String[relatedAttributes.length];
        System.arraycopy(relatedAttributes, 0, this.relatedAttributes, 0, relatedAttributes.length);
    }

    public Element getElement() {
        return this.auimlElement;
    }

    public boolean isSubElementOf(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Element name passed to AUIMLTag.isSubElementOf() can not be null");
        }
        Element e = this.auimlElement;
        e = e.getParentNode() != null && e.getParentNode() instanceof Element ? (Element)e.getParentNode() : null;
        while (e != null) {
            if (e.getTagName().equals(elementName)) {
                return true;
            }
            if (e.getParentNode() != null && e.getParentNode() instanceof Element) {
                e = (Element)e.getParentNode();
                continue;
            }
            e = null;
        }
        return false;
    }

    public boolean isPanelElement() {
        return this.isSubElementOf("DATA-GROUP");
    }

    public boolean isMenuElement() {
        return this.isSubElementOf("ACTION-GROUP");
    }

    public boolean isTableElement() {
        return this.isSubElementOf("TABLE");
    }

    public boolean isChoiceElement() {
        return this.isSubElementOf("CHOICE");
    }

    public String getContainingElementName() {
        Element tmp = this.auimlElement;
        if (this.auimlElement.getTagName().equals("DATA-GROUP")) {
            return this.auimlElement.getAttribute("NAME");
        }
        while (tmp.getParentNode() != null && tmp.getParentNode() instanceof Element) {
            tmp = (Element)tmp.getParentNode();
            String tmpName = tmp.getAttribute("NAME");
            if (!tmp.getTagName().equals("DATA-GROUP") && !tmp.getTagName().equals("GROUP") && !tmp.getTagName().equals("CHOICE")) continue;
            return tmpName;
        }
        return null;
    }

    public boolean isDirectChildOf(String tagName) {
        return this.auimlElement.getParentNode() != null && this.auimlElement.getParentNode() instanceof Element && ((Element)this.auimlElement.getParentNode()).getTagName().equals(tagName);
    }

    public Element findPosition() {
        if (this.position == null) {
            Element containingTable = null;
            if (this.getHmcmlMountPoint() != null) {
                containingTable = this.getHmcmlMountPoint();
                boolean found = false;
                if (containingTable != null && containingTable.getTagName().equals("table") && containingTable.getAttribute("name").equals(this.getContainingElementName())) {
                    found = true;
                }
                while (containingTable != null && !found) {
                    if (containingTable.getParentNode() instanceof Element) {
                        if ((containingTable = (Element)containingTable.getParentNode()) == null || !containingTable.getTagName().equals("table") || !containingTable.getAttribute("name").equals(this.getContainingElementName())) continue;
                        found = true;
                        continue;
                    }
                    containingTable = null;
                }
            }
            if (containingTable == null) {
                containingTable = TagUtils.findTable(this.getContainingElementName(), this.hmcmlDocument);
            }
            this.position = TagUtils.findCell(this.getAttribute("CELL"), containingTable);
            if (this.position == null) {
                String tagName = this.auimlElement.getTagName();
                if (tagName == null) {
                    tagName = "";
                }
                if (tagName.equals("STRING") || tagName.equals("NUMBER") || tagName.equals("DATE") || tagName.equals("TIME") || tagName.equals("BOOLEAN") || tagName.equals("CHOICE") || tagName.equals("GROUP") || tagName.equals("TABLE") || tagName.equals("TREE") || tagName.equals("ACTION") && !this.isMenuElement()) {
                    if (this.isTableElement()) {
                        return null;
                    }
                    if (containingTable != null) {
                        NodeList trs = containingTable.getElementsByTagName("tr");
                        int trsLength = trs.getLength();
                        for (int i = 0; i < trsLength; ++i) {
                            if (trs.item(i).getParentNode() != containingTable) continue;
                            NodeList tds = ((Element)trs.item(i)).getElementsByTagName("td");
                            int tdsLength = tds.getLength();
                            for (int j = 0; j < tdsLength; ++j) {
                                if (tds.item(j).getParentNode() != trs.item(i) || tds.item(j).getChildNodes().getLength() != 0) continue;
                                this.position = (Element)tds.item(j);
                                j = tdsLength;
                                i = trsLength;
                            }
                        }
                        if (this.position == null) {
                            int i;
                            Element tr = this.hmcmlDocument.createElement("tr");
                            containingTable.appendChild(tr);
                            int colspan = 0;
                            trsLength = trs.getLength();
                            for (i = 0; i < trsLength; ++i) {
                                if (trs.item(i).getParentNode() != containingTable) continue;
                                NodeList tds = ((Element)trs.item(i)).getElementsByTagName("td");
                                int tdsLength = tds.getLength();
                                for (int j = 0; j < tdsLength; ++j) {
                                    Element tdtmp = (Element)tds.item(j);
                                    if (tdtmp.getParentNode() != trs.item(i)) continue;
                                    String tdcolspan = tdtmp.getAttribute("colspan");
                                    if (tdcolspan != null && !tdcolspan.trim().equals("")) {
                                        colspan += Integer.parseInt(tdcolspan);
                                        continue;
                                    }
                                    ++colspan;
                                }
                                i = trsLength;
                            }
                            for (i = 0; i < colspan; ++i) {
                                Element td = this.hmcmlDocument.createElement("td");
                                tr.appendChild(td);
                            }
                            this.position = (Element)tr.getFirstChild();
                        }
                    }
                }
            }
        }
        return this.position;
    }

    public String getRelatedAttribute(String attributeName) {
        if (this.relatedAttributes != null) {
            int loopIndex = this.relatedAttributes.length;
            for (int i = 0; i < loopIndex; ++i) {
                if (this.relatedAttributes[i] == null) continue;
                StringTokenizer st = new StringTokenizer(this.relatedAttributes[i], ";");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    int separator = s.indexOf(":");
                    if (separator <= 0 || !s.substring(0, separator).equals(attributeName)) continue;
                    return s.substring(separator + 1);
                }
            }
        }
        return "";
    }

    public String getAttribute(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("getAttribute(String): attributeName can not be null");
        }
        String auimlElementAttribute = this.auimlElement.getAttribute(attributeName);
        if (auimlElementAttribute != null && !auimlElementAttribute.equals("")) {
            return auimlElementAttribute;
        }
        if (this.rscAttributes != null) {
            StringTokenizer st = new StringTokenizer(this.rscAttributes, ";");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int separator = s.indexOf(":");
                if (separator <= 0 || !s.substring(0, separator).equals(attributeName)) continue;
                return s.substring(separator + 1);
            }
        }
        if (attributeName.equals("COLSPAN") || attributeName.equals("INSETLEFT")) {
            return "";
        }
        if (this.relatedAttributes != null) {
            int loopIndex = this.relatedAttributes.length;
            for (int i = 0; i < loopIndex; ++i) {
                if (this.relatedAttributes[i] == null) continue;
                StringTokenizer st = new StringTokenizer(this.relatedAttributes[i], ";");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    int separator = s.indexOf(":");
                    if (separator <= 0 || !s.substring(0, separator).equals(attributeName)) continue;
                    return s.substring(separator + 1);
                }
            }
        }
        return "";
    }

    public String getBindingProperty() {
        int i;
        String binding = this.getAttribute("BINDING");
        if (binding == null) {
            binding = "";
        }
        if ((i = binding.indexOf("#")) >= 0) {
            binding = binding.substring(i + 1);
        }
        binding = Introspector.decapitalize(binding);
        return binding;
    }

    public void adjustColspan() {
        if (this.getHmcmlElement() != null) {
            Element cell = TagUtils.findParentWithTagName(this.getHmcmlElement(), "td");
            TagUtils.adjustColspan(this.getAttribute("COLSPAN"), cell);
        }
    }

    public void adjustRowspan() {
        if (this.getHmcmlElement() != null && this.getHmcmlElement().getParentNode() != null && this.getHmcmlElement().getParentNode() instanceof Element && ((Element)this.getHmcmlElement().getParentNode()).getTagName().equals("td")) {
            Element cell = (Element)this.getHmcmlElement().getParentNode();
            TagUtils.adjustRowspan(this.getAttribute("ROWSPAN"), cell);
        }
    }

    void adjustAnchor() {
        String anchor = this.getAttribute("ANCHOR");
        if (anchor == null || anchor.equals("")) {
            anchor = "NORTHWEST";
        }
        if (this.getHmcmlElement() != null && this.getHmcmlElement().getParentNode() != null && this.getHmcmlElement().getParentNode() instanceof Element && ((Element)this.getHmcmlElement().getParentNode()).getTagName().equals("td")) {
            Element cell = (Element)this.getHmcmlElement().getParentNode();
            if (anchor.equals("SOUTHWEST")) {
                cell.setAttribute("valign", "bottom");
                cell.setAttribute("align", "left");
            } else if (anchor.equals("SOUTHEAST")) {
                cell.setAttribute("valign", "bottom");
                cell.setAttribute("align", "right");
            } else if (anchor.equals("SOUTH")) {
                cell.setAttribute("valign", "bottom");
                cell.setAttribute("align", "center");
            } else if (anchor.equals("NORTHWEST")) {
                cell.setAttribute("valign", "top");
                cell.setAttribute("align", "left");
            } else if (anchor.equals("NORTHEAST")) {
                cell.setAttribute("valign", "top");
                cell.setAttribute("align", "right");
            } else if (anchor.equals("NORTH")) {
                cell.setAttribute("valign", "top");
                cell.setAttribute("align", "center");
            } else if (anchor.equals("WEST")) {
                cell.setAttribute("valign", "middle");
                cell.setAttribute("align", "left");
            } else if (anchor.equals("EAST")) {
                cell.setAttribute("valign", "middle");
                cell.setAttribute("align", "right");
            } else if (anchor.equals("CENTER")) {
                cell.setAttribute("valign", "middle");
                cell.setAttribute("align", "center");
            }
        }
    }

    public void adjustInsetLeft() {
        String insetleft = this.getAttribute("INSETLEFT");
        if (insetleft != null && !insetleft.equals("")) {
            Element cell = null;
            if (this.hmcmlElement != null) {
                cell = TagUtils.findParentWithTagName(this.hmcmlElement, "td");
            }
            if (cell == null) {
                cell = this.findPosition();
            }
            if (cell != null) {
                int inset = Integer.parseInt(insetleft) / insetConversionFactor;
                StringBuffer spacingBuffer = new StringBuffer();
                for (int i = 0; i < inset; ++i) {
                    spacingBuffer.append("&nbsp;");
                }
                Text spacingNode = this.hmcmlDocument.createTextNode(spacingBuffer.toString());
                cell.insertBefore(spacingNode, cell.getFirstChild());
            }
        }
    }

    public void adjustTag() {
        this.adjustColspan();
        this.adjustRowspan();
        this.adjustInsetLeft();
        this.adjustAnchor();
    }

    public String fetchResourceValue(String itemName) {
        return this.fetchResourceValue(itemName, true, true, true, true);
    }

    public String fetchResourceValue(String itemName, boolean fixQuotes, boolean fixBRTags, boolean stripHTML, boolean stripSwing) {
        ResourceBundle properties = (ResourceBundle)AUIMLParser.resourceMap.get(this.getAttribute("RSC-NAME"));
        if (properties == null) {
            properties = ResourceBundle.getBundle(this.getAttribute("RSC-NAME"));
            AUIMLParser.resourceMap.put(this.getAttribute("RSC-NAME"), properties);
        }
        String value = null;
        try {
            value = properties.getString(itemName);
        }
        catch (Exception e) {
            value = "";
        }
        if (value == null) {
            value = "";
        }
        value = AuimlJSPTools.cleanupResource(value, fixQuotes, fixBRTags, stripHTML, stripSwing);
        return value;
    }

    void addHmcId(Element element, String value) {
        if (value == null || value.equals("") || element == null) {
            return;
        }
        NodeList elements = element.getNamespaceURI() == null || element.getNamespaceURI().equals("") ? this.hmcmlDocument.getElementsByTagName(element.getTagName()) : this.hmcmlDocument.getElementsByTagNameNS(element.getNamespaceURI(), element.getTagName());
        boolean found = false;
        int elementsLength = elements.getLength();
        for (int i = 0; i < elementsLength; ++i) {
            String tmpHmcId = ((Element)elements.item(i)).getAttributeNS("hmc", "id");
            if (tmpHmcId == null || !tmpHmcId.equals(value)) continue;
            found = true;
            i = elements.getLength();
        }
        if (!found) {
            if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("hmc")) {
                element.setAttribute("id", value);
            } else {
                element.setAttributeNS("hmc", "id", value);
            }
        }
    }

    boolean isValidWclFdaComponent(String tagName) {
        if (tagName == null) {
            return false;
        }
        return tagName.equals("WButton") || tagName.equals("WImageButton") || tagName.equals("WCheckBox") || tagName.equals("WComboBox") || tagName.equals("WRadioButtonGroup") || tagName.equals("WSelectionBox") || tagName.equals("WTextArea") || tagName.equals("WTextEntry") || tagName.equals("WHyperlink") || tagName.equals("WDateChooser") || tagName.equals("WTimeChooser") || tagName.equals("WSkinChooser");
    }

    public void addHelpToHmcmlElement() {
        if (this.getHmcmlElement() == null) {
            return;
        }
        String topic = null;
        String helpId = this.getAttribute("HELPID");
        topic = helpId == null || helpId.equals("") ? this.getAttribute("RSC-NAME") + "." + this.getAttribute("PANEL-NAME") + "." + this.getAttribute("NAME") : helpId;
        this.addHelpToHmcmlElement(this.getHmcmlElement(), topic);
    }

    public void addHelpToHmcmlElement(Element elementToModify, String topic) {
        if (elementToModify == null || topic == null) {
            return;
        }
        String helpLocation = null;
        String helpset = this.getAttribute("HELPSET");
        if (helpset != null && !helpset.equals("") && helpset.endsWith("help.hs")) {
            helpLocation = helpset.substring(0, helpset.indexOf("help.hs"));
        }
        if (helpLocation == null) {
            helpLocation = HelpRecordUtility.getHelpFileLocation(this.getAttribute("RSC-NAME"));
        }
        if (helpLocation.equals("")) {
            return;
        }
        String title = null;
        String text = null;
        String locationURL = "jar:file:" + helpLocation + "help.jar!/" + helpLocation + "help.hs";
        Object o = AUIMLParser.resourceMap.get(this.getAttribute("RSC-NAME") + "FDA");
        if (o instanceof Properties) {
            Properties fdaprops = (Properties)o;
            try {
                FDARetriever fdaRetriever = new FDARetriever(locationURL);
                fdaRetriever.setTopicId(topic);
                title = fdaRetriever.getTitle();
                text = fdaRetriever.getText();
                title = AuimlJSPTools.cleanupResource(title, true, true, true, false);
                String text1 = AuimlJSPTools.cleanupResource(text, true, true, true, false);
                if (text != null && !text.equals("") && title != null && !title.equals("")) {
                    if (elementToModify.getNamespaceURI() == null || !elementToModify.getNamespaceURI().equals("wcl")) {
                        elementToModify.setAttributeNS("wcl", "fdaTitle", title);
                        elementToModify.setAttributeNS("wcl", "fdaText", text1);
                    } else {
                        elementToModify.setAttribute("fdaTitle", title);
                        elementToModify.setAttribute("fdaText", text1);
                    }
                }
                if (AUIMLParser.isBuildFDAProperties()) {
                    String text2 = AuimlJSPTools.cleanupResource(text, false, true, true, false);
                    String rscName = this.getAttribute("RSC-NAME");
                    fdaprops.put(topic.substring(rscName.length() + 1) + ".fdaTitle", title);
                    fdaprops.put(topic.substring(rscName.length() + 1) + ".fdaText", text2);
                }
            }
            catch (Exception e) {}
        } else {
            ResourceBundle fdabundle = (ResourceBundle)o;
            String rscName = this.getAttribute("RSC-NAME");
            Element fmtMessage1 = this.hmcmlDocument.createElementNS("fmt", "message");
            Element fmtMessage2 = this.hmcmlDocument.createElementNS("fmt", "message");
            String titleKey = topic.substring(rscName.length() + 1) + ".fdaTitle";
            String textKey = topic.substring(rscName.length() + 1) + ".fdaText";
            fmtMessage1.setAttribute("key", titleKey);
            fmtMessage1.setAttribute("var", titleKey.replace('.', '_'));
            fmtMessage1.setAttribute("bundle", "${fdabundle}");
            fmtMessage2.setAttribute("key", textKey);
            fmtMessage2.setAttribute("var", textKey.replace('.', '_'));
            fmtMessage2.setAttribute("bundle", "${fdabundle}");
            elementToModify.getParentNode().insertBefore(fmtMessage1, elementToModify.getParentNode().getFirstChild());
            elementToModify.getParentNode().insertBefore(fmtMessage2, elementToModify.getParentNode().getFirstChild());
            if (elementToModify.getNamespaceURI() == null || !elementToModify.getNamespaceURI().equals("wcl")) {
                elementToModify.setAttributeNS("wcl", "fdaTitle", "${" + titleKey.replace('.', '_') + "}");
                elementToModify.setAttributeNS("wcl", "fdaText", "${" + textKey.replace('.', '_') + "}");
            } else {
                elementToModify.setAttribute("fdaTitle", "${" + titleKey.replace('.', '_') + "}");
                elementToModify.setAttribute("fdaText", "${" + textKey.replace('.', '_') + "}");
            }
        }
    }
}

